#!/bin/bash

xmldir=$SIXTE/share/sixte/instruments/xrism

# Resolve
$SIXTE/bin/makespec \
    EvtFile=output/evt_resolve.fits \
    Spectrum=output/spec_resolve.pha \
    RSPPath=${xmldir}/resolve/ \
    clobber=yes


# Xtend
$SIXTE/bin/makespec \
    EvtFile=output/evt_xtend.fits \
    Spectrum=output/spec_xtend.pha \
    RSPPath=${xmldir}/xtend/ \
    clobber=yes

# Note:
# it is also possible to perform filtering here using the
# FITS extended filename syntax
# for example, using
#  EvtFile="output/evt_resolve.fits[EVENTS][GRADING==0]"
# or using the additional argument
#  EventFilter="GRADING==0"
# will extract only events where the GRADING column equals 0,
# which means selecting only Hp events
