#!/bin/bash

# create an image of the source per detector
# here, we use the same tool (imgev) with different parameters

# Resolve
# rationale for numbers CRVAL,CRPIX,CDELT:
# CDELT is given as atan(pixel_pitch/focal_len) in degrees
# for CRPIX/CRVAL: We currently assume that the focal point
# is in the exact center of the array
$SIXTE/bin/imgev                                \
    EvtFile=output/evt_resolve.fits             \
    Image=output/img_resolve.fits               \
    CoordinateSystem=0 Projection=TAN           \
    NAXIS1=6 NAXIS2=6                           \
    CUNIT1=deg CUNIT2=deg                       \
    CRVAL1=0.0 CRVAL2=0.0                       \
    CRPIX1=3.5 CRPIX2=3.5                       \
    CDELT1=-85.12516e-04 CDELT2=85.12516e-04    \
    history=true clobber=yes

# xtend
# rationale for numbers CRVAL,CRPIX,CDELT:
# CDELT is given as atan(pixel_size/focal_len) in degrees
# for CRPIX/CRVAL: We assume that upper right edge of CCD2
# is located 8mm from the focal point in both DETX and DETY
$SIXTE/bin/imgev                                \
    EvtFile=output/evt_xtend.fits               \
    Image=output/img_xtend.fits                 \
    CoordinateSystem=0 Projection=TAN           \
    NAXIS1=640 NAXIS2=640                       \
    CUNIT1=deg CUNIT2=deg                       \
    CRVAL1=-0.0 CRVAL2=0.0                      \
    CRPIX1=473.34 CRPIX2=473.34                 \
    CDELT1=-4.9110668e-04 CDELT2=4.9110668e-04  \
    history=true clobber=yes
