#!/bin/bash

base=mcrab_lines
xmldir=$SIXTE/share/sixte/instruments/xrism

# run simulation for both detectors
# for a microcalorimeter like Resolve, we need the xifupipeline tool,
# while a CCD like Xtend can be run using the runsixt tool, as long
# as it is only a single CCD - see M31 simulation for the full array

# simulate microcalorimeter for Resolve
# this requires use of the tool xifupipeline
# in the future, we will have one tool "sixtesim", which
# runs any detector type and only needs one XML file

xifupipeline \
  XMLFile=${xmldir}/resolve/resolve_baseline_GVclosed.xml \
  AdvXml=${xmldir}/resolve/resolve_detector.xml \
  Simput=${base}.simput \
  EvtFile=output/evt_resolve.fits \
  RA=0.0 Dec=0.0 \
  Exposure=200000


# simulate only a single chip for Xtend
runsixt \
  XMLFile=${xmldir}/xtend/xtend_ccd2.xml \
  Simput=${base}.simput \
  EvtFile=output/evt_xtend.fits \
  RA=0.0 Dec=0.0 \
  Exposure=100000
