from astropy.io import fits
import numpy as np
import matplotlib.pyplot as plt
import sys

fluxfac = np.array([10,50,100,500,1000])
grades = np.arange(5)
gradenames = ["Hp","Mp","Ms","Lp","Ls"]

filters = ["", "fwND_"]

fig,ax = plt.subplots(len(filters))
for i_filt in range(len(filters)):

    # save grading information in a 2D array
    hists = np.zeros((len(fluxfac),len(grades)))

    filt = filters[i_filt]

    # loop over simulation output files
    for i_flux in range(len(fluxfac)):
        infile = "output/evt_resolve_{}x{}.fits".format(filt,fluxfac[i_flux])

        # for each event, grading information is stored in the "GRADING" column
        evtgrades = fits.open(infile)[1].data["GRADING"]

        # determine the distribution of grades for this observation
        dist,bins = np.histogram(evtgrades,np.arange(6))
        hists[i_flux,:] = dist /np.sum(dist)

    # plot the grade distribution
    for grad in grades:
        ax[i_filt].plot(fluxfac,hists[:,grad], label=gradenames[grad])

    # set labels etc.
    ax[i_filt].set_xscale("log")
    ax[i_filt].legend()

    if (len(filt)==0):
        ax[i_filt].text(fluxfac[-1],0.9,"No Filter",ha="right")
    else:
        ax[i_filt].text(fluxfac[-1],0.9,filt[:-1],ha="right")

    ax[i_filt].set_xlabel("Source flux [mcrab]")
    ax[i_filt].set_ylabel("Branching ratio")

plt.show()
