#!/bin/bash

# run only resolve simulations, with increasing flux

xmldir=$SIXTE/share/sixte/instruments/xrism/resolve

for fluxfac in 10 50 100 500 1000
do
  # use FITS extended filename syntax to scale the source flux
  INFILE="mcrab.simput[SRC_CAT][col FLUX=FLUX*${fluxfac},*]"

  # scale exposure time inversely with flux to keep constant number
  # of photons
  EXP=$(python -c "print(20000/${fluxfac})")

  # run a simulation with the standard configuration
  xifupipeline \
    XMLFile=${xmldir}/resolve_baseline_GVclosed.xml \
    AdvXml=${xmldir}/resolve_detector.xml \
    Simput="${INFILE}" Exposure=${EXP} \
    EvtFile=output/evt_resolve_x${fluxfac}.fits \
    RA=0.0 Dec=0.0

  # and a simulation with an additional filter
  xifupipeline \
    XMLFile=${xmldir}/resolve_fwND_GVclosed.xml \
    AdvXml=${xmldir}/resolve_detector.xml \
    Simput="${INFILE}" Exposure=${EXP} \
    EvtFile=output/evt_resolve_fwND_x${fluxfac}.fits \
    RA=0.0 Dec=0.0
done
