#!/bin/bash

# create an image of the source per detector
# here, we use the same tool (imgev) with different parameters
SrcRA=81.259404
SrcDec=69.6437

# Since this source is no longer at (0,0), we need to adjust
# CRVAL in imgev

# Resolve
$SIXTE/bin/imgev \
    EvtFile=output/evt_resolve.fits \
    Image=output/img_resolve.fits \
    CoordinateSystem=0 Projection=TAN \
    NAXIS1=6 NAXIS2=6 \
    CUNIT1=deg CUNIT2=deg \
    CRVAL1=${SrcRA} CRVAL2=${SrcDec} \
    CRPIX1=3.5 CRPIX2=3.5 \
    CDELT1=-85.12516e-04 CDELT2=85.12516e-04 \
    history=true clobber=yes

# Xtend
$SIXTE/bin/imgev \
    EvtFile=output/evt_xtend.fits \
    Image=output/img_xtend.fits \
    CoordinateSystem=0 Projection=TAN \
    NAXIS1=640 NAXIS2=640 \
    CUNIT1=deg CUNIT2=deg \
    CRVAL1=${SrcRA} CRVAL2=${SrcDec} \
    CRPIX1=473.34 CRPIX2=473.34 \
    CDELT1=-4.9110668e-04 CDELT2=4.9110668e-04  \
    history=true clobber=yes
