#!/bin/bash

xmldir=$SIXTE/share/sixte/instruments/xrism

SrcRA=81.259404
SrcDec=69.6437

# the simulation calls are the same as before, just with a different
# pointing

# simulate microcalorimeter for Resolve
# image was taken from Dec 4 to 11, so maximum 7 days, so about 600ks
# assume 50% efficiency, round down to 300 ks exposure
xifupipeline \
  XMLFile=${xmldir}/resolve/resolve_baseline_GVclosed.xml \
  AdvXml=${xmldir}/resolve/resolve_detector.xml \
  Simput=n132d_flat.simput \
  EvtFile=output/evt_resolve.fits \
  RA=${SrcRA} Dec=${SrcDec} \
  Exposure=300000

# radec2xy adds WCS coordinates to an event file
radec2xy \
  EvtFile=output/evt_resolve.fits \
  RefRA=${SrcRA} RefDec=${SrcDec} Projection=SIN

# simulate only a single chip for Xtend
# also use a shorter exposure, as Xtend has no Gate Valve
# this is still plenty of photons
runsixt \
  XMLFile=${xmldir}/xtend/xtend_ccd2.xml \
  Simput=n132d_flat.simput \
  EvtFile=output/evt_xtend.fits \
  RA=${SrcRA} Dec=${SrcDec} \
  Exposure=10000

radec2xy \
  EvtFile=output/evt_xtend.fits \
  RefRA=${SrcRA} RefDec=${SrcDec} Projection=SIN
