/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2020 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "Carrier.h"
#include "Detector.h"
#include "GTICollection.h"
#include "healog.h"
#include "ObsInfo.h"
#include "Parameters.h"
#include "PhotonGeneration.h"
#include "PhotonImaging.h"
#include "SimulationParameters.h"
#include "SixteAUXBackground.h"
#include "SixteBackground.h"
#include "SixteException.h"
#include "SixteProgressbar.h"
#include "sixte_random.h"
#include "TelescopeModule.h"
#include "XMLData.h"

extern "C" {
// HDgti_grow in headas_gti.h uses "new" as a variable name which is a reserved
// keyword in C++.
#define new extern_new

#include "eventfile.h"
#include "geninst.h"
#include "impactfile.h"
#include "phdet.h"
#include "phimg.h"
#include "phpat.h"
#include "phproj.h"
#include "vector.h"
#include "sixt.h"

#undef new
}

namespace sixte {

class Simulator {
 public:
  Simulator(sixte::SimulationParameters& sim_params,
            std::vector<sixte::XMLData>& xml_datas,
            std::vector<sixte::XMLData>& xml_tel_datas,
            std::vector<ObsInfo>& obs_infos,
            const std::vector<sixte::ObsInfo>& obs_tel_infos,
            const GTICollection& gti_collection);

  void runSimulation();

 private:
  void runObservation();
  void runPostprocessing();
  void setDetectorStartTime(double tstart);

  CarrierPtr getNextSrcPhotonCarrier(std::pair<double, double> dt);
  CarrierPtr getNextCarrierOfType(const PhotonMetainfo& photon_metainfo, std::pair<double, double> dt);

  NewAttitude attitude_;

  const GTICollection& gti_collection_;
  std::vector<ObsInfo> obs_infos_;
  std::optional<SimulationParameters> sim_params_;
//  size_t num_xmls_;
  size_t num_tels_;
  std::vector<size_t> num_chips_;
  size_t carrier_buffer_max_size_;

  std::vector<PhotonImaging> photon_imaging_;
  PhotonGeneration photon_generation_;
  std::vector<std::vector<Detector>> detector_;
  //TODO: std::vector<TelescopeModule> telescope_modules_;

  std::vector<std::vector<PHABackground>> pha_background_;
  std::vector<std::vector<AUXBackground>> aux_background_;
  bool aux_background_initialized_{false};
  bool isTheseus_{false};
  bool show_progress_;
};

}
