/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "SixtePhoton.h"
#include "paraminput.h"
#include <CCfits>
#include <optional>
#include <healog.h>
#include "SixteCCFits.h"

namespace sixte {

class Parameters {
 public:
  Parameters()
  {
    impact_file = queryParameterString("ImpactList");
    piximpact_file = queryParameterString("PixImpList");
    xml_file = queryParameterString("XMLFile");
    clobber = queryParameterBool("clobber");
  }

  std::string impact_file;
  std::string piximpact_file;
  std::string xml_file;
  bool clobber;
};

std::optional<SixtePhoton> getImpact(sixte::Fitsfile& infile, size_t row);

}
