/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2020 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "Parameters.h"
#include "SixteCCFits.h"
#include "healog.h"
#include "ObsInfo.h"
#include "PhotonGeneration.h"
#include "PhotonImaging.h"
#include "SixteProgressbar.h"
#include "NewAttitude.h"
#include "GTICollection.h"
#include "SimulationParameters.h"
#include "SixteException.h"
#include "sixte_random.h"
#include "XMLData.h"

extern "C" {
// HDgti_grow in headas_gti.h uses "new" as a variable name which is a reserved
// keyword in C++.
#define new extern_new

#include "geninst.h"
#include "phproj.h"
#include "vector.h"
#include "sixt.h"

#undef new
}

namespace sixte {

class Parameters {
 public:
  Parameters() {
    attitude_dt = queryParameterDouble("dt");
    clobber = queryParameterBool("clobber");
    seed = queryParameterInt("Seed");
    show_progress = queryParameterBool("progressbar");
    photon_list = queryParameterString("PhotonList");
    impact_list = queryParameterString("ImpactList");
    xml_file = queryParameterString("XMLFile");
    gti_file = queryParameterString("GTIFile");
  }


  ObsPointing pointing;
  ObsTime time;

  std::string xml_file;
  std::string gti_file;
  std::string photon_list;
  std::string impact_list;
  double attitude_dt;
  bool clobber;
  int seed;
  bool show_progress;
};


class Simulator {
 public:
  Simulator(const Parameters& sim_params, XMLData& xml_data);

  void runSimulation();

 private:
  void runObservation();

  GTICollection gti_collection_;
  ObsInfo obs_info_;
  NewAttitude attitude_;

  PhotonImaging photon_imaging_;
  bool show_progress_;
  std::string photonfile_;
};

std::optional<SixtePhoton> getPhoton(sixte::Fitsfile &infile, size_t row);

}
