/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2020 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "Parameters.h"
#include "healog.h"
#include "ObsInfo.h"
#include "PhotonGeneration.h"
#include "PhotonImaging.h"
#include "SixteProgressbar.h"
#include "NewAttitude.h"
#include "GTICollection.h"
#include "SimulationParameters.h"
#include "SixteException.h"
#include "sixte_random.h"
#include "XMLData.h"
#include <vector>

extern "C" {
// HDgti_grow in headas_gti.h uses "new" as a variable name which is a reserved
// keyword in C++.
#define new extern_new

#include "geninst.h"
#include "phproj.h"
#include "vector.h"
#include "sixt.h"

#undef new
}

namespace sixte {

class Parameters {
 public:
  Parameters() {
    attitude_dt = queryParameterDouble("dt");
    clobber = queryParameterBool("clobber");
    seed = queryParameterInt("Seed");
    show_progress = queryParameterBool("progressbar");
    photon_list.push_back(queryParameterString("PhotonList"));
    xml_file = queryParameterString("XMLFile");
    gti_file = queryParameterString("GTIfile");
    simput_files = loadSIMPUTFilenames();
  }

  std::string xml_file;
  std::vector<std::string> simput_files;
  std::string gti_file;

  ObsPointing pointing;
  ObsTime time;

  std::vector<std::string> photon_list;
  double attitude_dt;
  bool clobber;
  int seed;
  bool show_progress;
};


class Simulator {
 public:
  Simulator(const Parameters& sim_params, std::vector<XMLData>& xml_data, const GTICollection& gtis, const std::vector<ObsInfo>& obs_infos);

  void runSimulation();

 private:
  void runObservation();


  const GTICollection& gti_collection_;
  NewAttitude attitude_;

  PhotonGeneration photon_generation_;
  double simtime;
  bool show_progress_;
};

}
