/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "NewEventfile.h"
#include "SixteCCFits.h"
#include <string>
#include "RegionFiltering.h"
#include "GTICollection.h"

#include "arf.h"
#include "rmf.h"


enum SignalType {SIGNAL, PHA, PI};

/* command line parameters */
struct ClinePars {
  std::string EvtFile;
  std::string EventFilter;
  std::string Spectrum;
  std::string RSPPath;
  std::string ARFfile;
  std::string RMFfile;

  std::string GTIfile;
  std::string regfile;

  int Seed;
  bool clobber;
  bool usepha;
};

ClinePars read_par();

struct HeaderVals {
  std::string telescop;
  std::string instrume;
  std::string filter;
  std::string dateobs;
  std::string timeobs;
  std::string dateend;
  std::string timeend;
  std::string ancrfile;
  std::string respfile;
  std::string backfile = "";
  long detchans;
  std::string corrfile = "";
  double exposure;
  bool poiserr = true;
  std::string pha2pi;
};

void getHeaderVals(HeaderVals &vals,
    const CCfits::HDU* hdu,
    const sixte::GTICollection &gtis);

sixte::GTICollection getGTIs(const ClinePars &params);

// function to filter ra/dec for GTI
bool filterTime(const std::vector<std::pair<double,double>>& gtibins, double time);
