/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "NewEventfile.h"
#include <CCfits>
#include <string>
#include "RegionFiltering.h"
#include "GTICollection.h"

// TODO update code to use new ARF and RMF classes
#include "arf.h"
#include "rmf.h"

/* command line parameters */
struct ClinePars {
  std::string EvtFile;
  std::string LightCurve;

  std::string GTIfile;
  std::string regfile;

  double tstart;
  double dt;
  double length;
  double Emin;
  double Emax;
  long Chanmin;
  long Chanmax;
  std::string Chantype;

  bool clobber;
  bool usepha;
};

ClinePars read_par();

struct HeaderVals {
  std::string telescop;
  std::string instrume;
  std::string filter;
  double mjdref;
  double timezero;
};

void getHeaderVals(HeaderVals &vals,
    const CCfits::HDU* hdu,
    const sixte::GTICollection &gtis);

sixte::GTICollection getGTIs(const ClinePars &params);

// function to get SAORegion and WCS
SAORegion* getRegion(const std::string &regfile, CCfits::HDU &hdu);

// function to filter ra/dec for GTI
bool filterTime(const std::vector<std::pair<double,double>>& gtibins, double time);

// function to filter ra/dec for Region
bool filterReg(SAORegion* region, double X, double Y);
