/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2020 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include "CalibrationSource.h"
#include "SixteBackground.h"
#include "Parameters.h"
#include "Detector.h"
#include "healog.h"
#include "ObsInfo.h"
#include "SixteProgressbar.h"
#include "NewAttitude.h"
#include "GTICollection.h"
#include "SimulationParameters.h"
#include "SixteException.h"
#include "sixte_random.h"
#include "XMLData.h"

extern "C" {
// HDgti_grow in headas_gti.h uses "new" as a variable name which is a reserved
// keyword in C++.
#define new extern_new

#include "eventfile.h"
#include "geninst.h"
#include "impactfile.h"
#include "phdet.h"
#include "phimg.h"
#include "phpat.h"
#include "phproj.h"
#include "vector.h"
#include "sixt.h"

#undef new
}

namespace sixte {

class Parameters {
 public:
  Parameters()
  : output_files(std::nullopt, "none", std::nullopt, "none", std::nullopt, std::nullopt){
    skip_invalids = queryParameterBool("SkipInvalids");
    background = queryParameterBool("Background");
    calibration_source = queryParameterBool("CalibrationSource");
    seed = queryParameterInt("Seed");
    show_progress = queryParameterBool("progressbar");
    impact_file = queryParameterString("ImpactList");
    gti_file = queryParameterString("GTIFile");
    xml_file = queryParameterString("XMLFile");

    output_files.delete_rawdata=false;
  }

  OutputFiles output_files;
  ObsPointing pointing{"", 0.,0.,0.};
  ObsTime time;

  std::string raw_data;
  std::string impact_file;
  std::string xml_file;
  std::string gti_file;
  bool skip_invalids;
  bool background;
  bool calibration_source;
  int seed;
  bool show_progress;
};



class Simulator {
 public:
  Simulator(const Parameters& sim_params, XMLData& xml_data);
  GTICollection gti_collection_;

  void runSimulation();

 private:
  void runObservation();

  CarrierPtr getNextSrcPhotonCarrier(std::pair<double, double> dt);
  CarrierPtr getNextCalibrationSourceCarrier(std::pair<double, double> dt);
  CarrierPtr getNextCarrierOfType(const SrcType& src_type, std::pair<double, double> dt);

  ObsInfo obs_info_;

  Detector detector_;
  std::optional<PHABackground> pha_background_{std::nullopt};
  std::optional<ModulatedXraySource> calibration_source_{std::nullopt};
  Fitsfile impfile;
  bool show_progress_;
  long fitsrow = 1;
};

std::optional<SixtePhoton> getImpact(sixte::Fitsfile& infile, size_t row);

}
