/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                       Erlangen-Nuernberg
*/
#pragma once

#include "healog.h"
#include "paraminput.h"
#include "sixte_random.h"
#include "SixteException.h"
#include "XMLData.h"
#include "ArrayGeometry.h"
#include "Geometry.h"
#include "NewAttitude.h"
#include <cctype>
#include "SixteCCFits.h"
#include "Parameters.h"

extern "C" {
#include "vignetting.h"
#include "check_fov.h"
}

#define TOOLSUB exposure_map_main
#include "headas_main.c"

/* Program parameters */
struct expmap_parameters {
  expmap_parameters();

  std::string Attitude;    // filename of the attitude file
  std::string Vignetting;  // filename of the vignetting file
  std::string Exposuremap; // output: exposure map
  std::string RawExposuremap; // output: raw exposure map (no vignetting)
  std::string ProgressFile;
  std::string XMLFile;

  /** Telescope Pointing direction [deg]. */
  float RA, Dec, rollangle;

  /** Energy used for Vignetting */
  float vig_en;

  double TSTART;
  double timespan;
  /** Step width for the exposure map calculation [s]. */
  double dt;

  int seed;

  float fov_diameter;

  /** Number of interim maps to be stored. */
  int intermaps{0};

  bool clobber;

  /** Default input: wcs keywords */

  /** Coordinate system (0: equatorial, 1: galactic) */
  int coordinatesystem;
  /** Projection method (AIT, SIN). */
  std::string projection_type;
  /** WCS keywords */
  long naxis1, naxis2;
  std::string cunit1;
  std::string cunit2;
  float crval1, crval2;
  float crpix1, crpix2;
  float cdelt1, cdelt2;

  /** Alternative input: ra/dec range */

  /** Right ascension range [rad]. */
  double ra1, ra2;
  /** Declination range [rad]. */
  double dec1, dec2;
  /** Number of pixels in right ascension and declination. */
  int ra_bins, dec_bins;
  /** Projection method (1: AIT, 2: SIN). */
  int projection;
};

