/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "TemplateFitsFiles.h"
#include "SixteException.h"

using namespace sixte;

TEST_CASE("Template Fits Files Test", "[template_fits_files]") {
  
  SECTION("Event File") {
    /** test values: **/
    std::string filename = "test_eventfile_name.fits";
    std::string ref_filename = "./data/refdata/ref_wfi_evt_10mcrab.fits";
    
    std::unique_ptr<CCfits::FITS> ref_inFile = sixteOpenFITSFileRead(ref_filename, "ref event file");
    
    /** function to be tested: **/
    std::unique_ptr<CCfits::FITS> inFile = EventFileTemplate(filename);
    
    /** getting resulting test values **/
    auto &table = inFile->extension(1U);
    auto time_index = table.column("TIME").index();
    auto frame_index = table.column("FRAME").index();
    auto pha_index = table.column("PHA").index();
    auto pi_index = table.column("PI").index();
    auto signal_index = table.column("SIGNAL").index();
    auto rawx_index = table.column("RAWX").index();
    auto rawy_index = table.column("RAWY").index();
    auto ra_index = table.column("RA").index();
    auto dec_index = table.column("DEC").index();
    auto ph_id_index = table.column("PH_ID").index();
    auto src_id_index = table.column("SRC_ID").index();
    auto type_index = table.column("TYPE").index();
    auto npixels_index = table.column("NPIXELS").index();
    auto pileup_index = table.column("PILEUP").index();
    auto signals_index = table.column("SIGNALS").index();
    auto phas_index = table.column("PHAS").index();
    
    table = ref_inFile->extension(1U);
    auto ref_time_index = table.column("TIME").index();
    auto ref_frame_index = table.column("FRAME").index();
    auto ref_pha_index = table.column("PHA").index();
    auto ref_pi_index = table.column("PI").index();
    auto ref_signal_index = table.column("SIGNAL").index();
    auto ref_rawx_index = table.column("RAWX").index();
    auto ref_rawy_index = table.column("RAWY").index();
    auto ref_ra_index = table.column("RA").index();
    auto ref_dec_index = table.column("DEC").index();
    auto ref_ph_id_index = table.column("PH_ID").index();
    auto ref_src_id_index = table.column("SRC_ID").index();
    auto ref_type_index = table.column("TYPE").index();
    auto ref_npixels_index = table.column("NPIXELS").index();
    auto ref_pileup_index = table.column("PILEUP").index();
    auto ref_signals_index = table.column("SIGNALS").index();
    auto ref_phas_index = table.column("PHAS").index();
    
    /** test: **/
    REQUIRE(time_index == ref_time_index);
    REQUIRE(frame_index == ref_frame_index);
    REQUIRE(pha_index == ref_pha_index);
    REQUIRE(pi_index == ref_pi_index);
    REQUIRE(signal_index == ref_signal_index);
    REQUIRE(rawx_index == ref_rawx_index);
    REQUIRE(rawy_index == ref_rawy_index);
    REQUIRE(ra_index == ref_ra_index);
    REQUIRE(dec_index == ref_dec_index);
    REQUIRE(ph_id_index == ref_ph_id_index);
    REQUIRE(src_id_index == ref_src_id_index);
    REQUIRE(type_index == ref_type_index);
    REQUIRE(npixels_index == ref_npixels_index);
    REQUIRE(pileup_index == ref_pileup_index);
    REQUIRE(signals_index == ref_signals_index);
    REQUIRE(phas_index == ref_phas_index);
    
    /** clean-up */
    if (std::remove(filename.c_str()) != 0) {
      throw SixteException("Error removing file");
    }
  }
  
  SECTION("Impact File") {
    /** test values: */
    std::string filename = "test_impact_name";
    
    /** function to be tested: */
    std::unique_ptr<CCfits::FITS> inFile = ImpactFileTemplate(filename);
    
    /** test: */
    //TODO: test for certain keywords for pHDU and table extension
    
    /** clean-up */
    if (std::remove(filename.c_str()) != 0) {
      throw SixteException("Error removing file");
    }
  }
  
  SECTION("Photon File") {
    /** test values: */
    std::string filename = "test_impact_name";
    
    /** function to be tested: */
    std::unique_ptr<CCfits::FITS> inFile = PhotonFileTemplate(filename);
    
    /** test: */
    //TODO: test for certain keywords for pHDU and table extension
    
    /** clean-up */
    if (std::remove(filename.c_str()) != 0) {
      throw SixteException("Error removing file");
    }
  }
}
