/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "NewSourceCatalog.h"
#include "NewArf.h"

using namespace sixte;

TEST_CASE("SourceCatalog Test", "[Catalog_Test]") {
  std::string simput_file = "data/simputs/dummy.simput";
  std::vector<std::string> arf_filenames = {"data/instruments/dummy/dummy.arf"};
  NewArf new_arf(arf_filenames);
  
  NewSourceCatalog new_source_catalog(simput_file, new_arf);
  
  SECTION("sixteGenFoVXRayPhotons") {
    std::string att_filename = "data/instruments/dummy/attitude_lissajous.fits";
    double dt = 1;
    NewAttitude test_attitude(att_filename, dt);
    
    double fov = 1;
    double time = 1;
    double t1 = 1;
    LinkedPhoListElement* linked_pho_list_element = new_source_catalog.sixteGenFoVXRayPhotons(test_attitude, fov, time, t1);
    
    //TODO: get test values!
    double test_result_ra = 1;
    double test_result_dec = 1;
    double test_result_time = 1;
    double test_result_energy = 1;
    
    REQUIRE_THAT(linked_pho_list_element->photon.ra, Catch::Matchers::WithinAbs(test_result_ra, 1e-9));
    REQUIRE_THAT(linked_pho_list_element->photon.dec, Catch::Matchers::WithinAbs(test_result_dec, 1e-9));
    REQUIRE_THAT(linked_pho_list_element->photon.time, Catch::Matchers::WithinAbs(test_result_time, 1e-9));
    REQUIRE_THAT(linked_pho_list_element->photon.energy, Catch::Matchers::WithinAbs(test_result_energy, 1e-9));
  }
  
}