/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "NewRMF.h"

using namespace sixte;

/*
 * energy = 11.405 -> channel 1139;
 * energy_low = 11.40, energy_hi = 11.41
 */

TEST_CASE("RMF Test", "[rmf]") {
  //TODO: test for multiple rmfs && compare matrix extension
  std::string rmffilename = "data/instruments/athena-wfi/athena_wfi_sixte_v20200925.rmf";
  NewRMF rmf(rmffilename);
  NewRMF rmf2;
  
  SECTION("Get EBOUNDS Channel") {
    rmf.sixteLoadEbounds(rmffilename);
    long channel = rmf.sixteGetEBOUNDSChannel(11.405);
    REQUIRE(channel == 1139);
  }
  
  SECTION("Get EBOUNDS Energy Low and High") {
    double energy_low = 11.40, energy_hi = 11.41;
    std::pair<double, double> low_high = rmf.sixteGetEBOUNDSEnergyLoHi(1139);
    REQUIRE_THAT(low_high.first, Catch::Matchers::WithinAbs(energy_low, 1e-6));
    REQUIRE_THAT(low_high.second, Catch::Matchers::WithinAbs(energy_hi, 1e-6));
  }
}