/*
   This file is part of SIXTE.
   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.
   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.
   Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "NewSIXT.h"
#include "SixteException.h"
#include "raytracing/surface/Reflectivity.h"
#include "sixte_random.h"

using namespace sixte;

TEST_CASE("Reflectivity Test", "[reflectivity]") {
  std::cout << "[reflectivity]" << std::endl;

  const std::string path =
      "/home/neo/software/sixte/tools/raytracing/AtomicScatteringFactors_new.fits";
  initSixteRng(1000);
  auto copper = SurfaceElement(path, "CU");
  auto CU_reflect = copper.doesReflect(1000, 89);
  std::cout << "gold reflectivity val : " << copper.reflectivity(1000, 89*M_PI/180)
            << std::endl;
  std::cout << "does gold reflectivity val reflect : " << CU_reflect
            << std::endl;


  auto AL = SurfaceElement(path, "AL");
  auto AU = SurfaceElement(path, "AU");
  auto CU = SurfaceElement(path, "CU");
  auto FE = SurfaceElement(path, "FE");

  auto AL_test1 = AL.reflectivity(5000, 89*M_PI/180);
  // auto AL_test2 = AL.reflectivity(36000, 1);
  // auto AL_test3 = AL.reflectivity(-5000, 1);
  // auto AL_test4 = AL.reflectivity(5000, 0);
  // auto AL_test5 = AL.reflectivity(5000, 91);
  // auto AL_test6 = AL.reflectivity(5000, -1.5);
  auto AL_test7 = AL.reflectivity(5000, 88.5*M_PI/180);

  auto AU_test1 = AU.reflectivity(5000, 89*M_PI/180);
  // auto AU_test2 = AU.reflectivity(36000, 1);
  // auto AU_test3 = AU.reflectivity(-5000, 1);
  // auto AU_test4 = AU.reflectivity(5000, 0);
  // auto AU_test5 = AU.reflectivity(5000, 91);
  // auto AU_test6 = AU.reflectivity(5000, -1.5);
  auto AU_test7 = AU.reflectivity(5000, 88.5*M_PI/180);

  auto CU_test1 = CU.reflectivity(1000, 89*M_PI/180);
  auto CU_test2 = CU.reflectivity(5000, 89*M_PI/180);
  auto CU_test3 = CU.reflectivity(10000, 89*M_PI/180);

  auto FE_test1 = FE.reflectivity(5000, 89*M_PI/180);
  auto FE_test2 = FE.reflectivity(5000, 88.5*M_PI/180);
  auto FE_test3 = FE.reflectivity(10000, 89*M_PI/180);
  // auto FE_test4 = FE.reflectivity(5000, 0);
  // auto FE_test5 = FE.reflectivity(5000, 91);
  // auto FE_test6 = FE.reflectivity(5000, -1.5);
  // auto FE_test7 = FE.reflectivity(50000, 1.5);

  // Reference value are taken from python results
  auto al_ref_val1 = 0.0015512326531785495;
  auto al_ref_val2 = 4.704472941506305e-07;
  auto al_ref_val3 = 0.6789695293635477;
  auto al_ref_val4 = 0.9999999999999993;
  auto al_ref_val5 = 1.2339872025447782e-10;
  auto al_ref_val6 = 3565.4995211765454;
  auto al_ref_val7 = 0.00028046610383349957;

  auto au_ref_val1 = 0.13231203645180187;
  auto au_ref_val2 = 1.6657837322100795e-05;
  auto au_ref_val3 = 0.6761535397065311;
  auto au_ref_val4 = 0.9999999999999984;
  auto au_ref_val5 = 3.8438285531521706e-09;
  auto au_ref_val6 = 81.31946007129442;
  auto au_ref_val7 = 0.01229719453215425;

  auto cu_ref_val1 = 0.5882778603442683;
  auto cu_ref_val2 = 0.020148414525899924;
  auto cu_ref_val3 = 0.0007974845058441745;

  auto fe_ref_val1 = 0.014451831667367592;
  auto fe_ref_val2 = 0.002174839525839806;
  auto fe_ref_val3 = 0.000696162763639751;
  auto fe_ref_val4 = 0.9999999999999994;
  auto fe_ref_val5 = 8.521644332618851e-10;
  auto fe_ref_val6 = 459.80475737413633;
  auto fe_ref_val7 = 2.0053950718159164e-07;

  REQUIRE_THAT(al_ref_val1, Catch::Matchers::WithinAbs(AL_test1, 1e-9));
  // REQUIRE_THAT(al_ref_val2, Catch::Matchers::WithinAbs(AL_test2, 1e-9));
  // REQUIRE_THAT(al_ref_val3, Catch::Matchers::WithinAbs(AL_test3, 1e-9));
  // REQUIRE_THAT(al_ref_val4, Catch::Matchers::WithinAbs(AL_test4, 1e-9));
  // REQUIRE_THAT(al_ref_val5, Catch::Matchers::WithinAbs(AL_test5, 1e-9));
  // REQUIRE_THAT(al_ref_val6, Catch::Matchers::WithinAbs(AL_test6, 1e-9));
  REQUIRE_THAT(al_ref_val7, Catch::Matchers::WithinAbs(AL_test7, 1e-9));

  REQUIRE_THAT(au_ref_val1, Catch::Matchers::WithinAbs(AU_test1, 1e-9));
  // REQUIRE_THAT(au_ref_val2, Catch::Matchers::WithinAbs( AU_test2, 1e-9));
  // REQUIRE_THAT(au_ref_val3, Catch::Matchers::WithinAbs( AU_test3, 1e-9));
  // REQUIRE_THAT(au_ref_val4, Catch::Matchers::WithinAbs( AU_test4, 1e-9));
  // REQUIRE_THAT(au_ref_val5, Catch::Matchers::WithinAbs( AU_test5, 1e-9));
  // REQUIRE_THAT(au_ref_val6, Catch::Matchers::WithinAbs( AU_test6, 1e-9));
  REQUIRE_THAT(au_ref_val7, Catch::Matchers::WithinAbs(AU_test7, 1e-9));

  REQUIRE_THAT(cu_ref_val1, Catch::Matchers::WithinAbs(CU_test1, 1e-9));
  REQUIRE_THAT(cu_ref_val2, Catch::Matchers::WithinAbs(CU_test2, 1e-9));
  REQUIRE_THAT(cu_ref_val3, Catch::Matchers::WithinAbs(CU_test3, 1e-9));

  REQUIRE_THAT(fe_ref_val1, Catch::Matchers::WithinAbs(FE_test1, 1e-9));
  REQUIRE_THAT(fe_ref_val2, Catch::Matchers::WithinAbs(FE_test2, 1e-9));
  REQUIRE_THAT(fe_ref_val3, Catch::Matchers::WithinAbs(FE_test3, 1e-9));
  // REQUIRE_THAT(fe_ref_val4, Catch::Matchers::WithinAbs( FE_test4, 1e-9));
  // REQUIRE_THAT(fe_ref_val5, Catch::Matchers::WithinAbs( FE_test5, 1e-9));
  // REQUIRE_THAT(fe_ref_val6, Catch::Matchers::WithinAbs( FE_test6, 1e-9));
  // REQUIRE_THAT(fe_ref_val7, Catch::Matchers::WithinAbs( FE_test7, 1e-9));

  // const std::string path =
  //   "/home/pal/Reflectivity_database/AtomicScatteringFactors_new.fits";
  // auto gold = SurfaceElement(path, "AL");
  // auto AL_reflect = gold.does_reflect(5000,1);
  // std::cout << AL_reflect << std::endl;
  // SIXTE_OUT(AL.does_reflect());
  // SECTION("Check bool Values") {
  //   SIXTE_OUT(AL.does_reflect());
  //
  // }
}
