/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include <utility>
#include "PhotonMetainfo.h"
#include "Polygon.h"
#include "SixtePhoton.h"

using namespace sixte;

class Test_Photon {
 public:
  Test_Photon() : photon_metainfo(ph_id, src_id, tel_id, chip_id){};
  
  double time = 0.0;
  float energy = 2.5;
  std::pair<double, double> sky_position = std::make_pair(0., 0.);
  SixtePoint detector_pos{1., 1., 0.};
  
  long ph_id = 1;
  long src_id = 1;
  size_t tel_id = 1;
  size_t chip_id = 1;
  PhotonMetainfo photon_metainfo;
  
  SixtePhoton return_sixte_photon(const std::string& sky_or_det);
};

SixtePhoton Test_Photon::return_sixte_photon(const std::string& sky_or_det) {
  photon_metainfo.ph_id_=ph_id;
  photon_metainfo.src_id_=src_id;
  photon_metainfo.tel_id_=tel_id;
  
  if (sky_or_det == "sky") {
    SixtePhoton sixte_photon(time, energy, sky_position, photon_metainfo);
    return sixte_photon;
  } else {
    SixtePhoton sixte_photon(time, energy, detector_pos, photon_metainfo);
    return sixte_photon;
  }
}