/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "Parameters.h"

#include "XMLData.h"

using namespace sixte;

TEST_CASE("Parameters Test", "[parameters]") {
  
  std::vector<std::string> xml_filenames = {"./data/instruments/athena-wfi/ld_wfi_ff_large_all_chips.xml"};
  
  SECTION("divide xmls for different detectors") {
    //TODO: remove test xml
    auto detector_xmls = detectorXMLs(xml_filenames).xml_documents;
    
    // for testing: write out the generated XMLs
    for (size_t ii=0; ii<detector_xmls.size(); ii++) {
      std::string fname = "chip" + std::to_string(ii) + ".xml";
      detector_xmls[ii].save_file(fname.c_str());
    }
  }
  
  SECTION("get element attribute value as double") {
    std::string xml_filename = "./chip0.xml";
    pugi::xml_document xml_document;
    xml_document.load_file(xml_filename.c_str());

    XMLData xml_data(xml_document, "./");

    /** test values: */
    std::string test_element = "wcs";
    std::string test_attribute = "xrpix";

    /** function to be tested: */
    double test_sample = xml_data.child("detector").child(test_element).attributeAsDouble(test_attribute);

    /** test: */
    double sample_solution = 256.5;
    REQUIRE_THAT(test_sample, Catch::Matchers::WithinAbs(sample_solution, 1e-9));
  }

  SECTION("clean-up") {
    auto detector_xmls = detectorXMLs(xml_filenames).xml_documents;

    for (size_t ii=0; ii<detector_xmls.size(); ii++) {
      std::string fname = "chip" + std::to_string(ii) + ".xml";
      if (std::remove(fname.c_str()) != 0) {
        throw SixteException("Failed to remove output xmlfile");
      }
    }
  }
}