/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2023 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "NewEventfile.h"
#include "NewRMF.h"
#include "XMLData.h"


using namespace sixte;

TEST_CASE("Eventfile Test", "[eventfile]") {
  std::string event_filename = "test_eventfile.fits";
  bool clobber = true;
  
  std::string xml_filename = "data/instruments/dummy/default_extended.xml";
  pugi::xml_document xml_file;
  xml_file.load_file(xml_filename.c_str());
  XMLData xml_data(xml_file, "data/instruments/dummy/");
  
  std::string gti_file = "NONE";
  std::string attitude_file = "data/instruments/dummy/attitude_lissajous.fits";
  double mjdref = 55000;
  double tstart = 23.433;
  double exposure = 5000.5;
  double pointing_ra = 45.789;
  double pointing_dec = 4.578;
  double rollangle = 23.709;
  ObsTime obs_time(mjdref, tstart, exposure);
  ObsPointing obs_pointing(attitude_file, pointing_ra, pointing_dec, rollangle);
  GTICollection gti_collection(gti_file, obs_time);
  ObsInfo obs_info(xml_data, obs_pointing, gti_collection);

  std::string rmf_filename = "data/instruments/athena-wfi/athena_wfi_sixte_v20200925.rmf";
  NewRMF rmf(rmf_filename);
  size_t rmf_first_channel = rmf.FirstChannel();
  size_t rmf_number_channels = rmf.NumberChannels();
  
  NewEventfile new_eventfile_1(event_filename, clobber, xml_data, obs_info);
  NewEventfile new_eventfile_2(event_filename, clobber, xml_data, obs_info, rmf_first_channel, rmf_number_channels);
  
  SECTION("Add Column to Event File") {
    std::string columnName = "PI";
    CCfits::ValueType type = CCfits::Tlong;
    long repeatWidth = 1;
    size_t hdu_num = 1;
    const std::string &colUnit = std::string("ADU");
    long decimals = -1;
    size_t colnum = 1;

    new_eventfile_1.addCol2EventFile(columnName, type, repeatWidth, hdu_num, colUnit, decimals, colnum);

    REQUIRE(new_eventfile_1.getColNum(columnName, 1U) != 0);
  }

  SECTION("Add, Update and Get Event from File") {
    NewEvent test_event;
    double signal_val = 5.2;
    PhotonMetainfo photon_metainfo(3, 2);
    double creation_time = 9.123;
    Signal signal(signal_val, photon_metainfo, creation_time);
    NewEvent event(signal, rmf, 1, 1, 1, 1);

    new_eventfile_1.addEvent2File(event, 1U);
    
    new_eventfile_1.updateEventInFile(1, event, 1U);

    NewEvent event2 = new_eventfile_1.getEventFromFile(1, 1U);
  }
  
  SECTION("Get Row Number") {
    size_t test_row_num = 1;
    size_t row_num = new_eventfile_1.getRowNum(1U);
    REQUIRE(row_num == test_row_num);
  }

  SECTION("Get and Update Key String") {
//    std::string test_keystring = "";
//    std::string keyname = "RESPFILE";
//    std::string ext_name = "EVENTS";
//    std::string key_string = new_eventfile_1.getKeyString(keyname, ext_name);
//
//    REQUIRE(key_string == test_keystring);
//
//    void updateKeyString(const std::string &keyname,
//                         const std::string &keyvar,
//                         const std::string &comment,
//                         T hdu_num_or_name) const;
//
//    std::string test_keystring = "";
//    std::string keyname = "";
//    std::string key_string = new_eventfile_1.getKeyString(keyname, 1U);
//
//    REQUIRE(key_string == test_keystring);

  }

  SECTION("Get Col Num") {
//    int test_col_num = 1;
//    int col_num =  new_eventfile_1.getColNum("", 1U);
//
//    REQUIRE(test_col_num == col_num);
  }
  
  SECTION("clean-up") {
    if (std::remove(event_filename.c_str()) != 0) {
      throw SixteException("Error removing file");
    }
  }
}