/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "Detector.h"

using namespace sixte;

TEST_CASE("Detector Test", "[detector]") {
  std::string xml_filename = "./data/instruments/athena-wfi/ld_wfi_ff_large.xml";
  XMLData xml_data(xml_filename);
  
  OutputFiles output_files;
  
  ObsPointing obs_pointing("none", 0, 0, 0);
  ObsTime obs_time(55000., 0, 10);
  GTICollection gti_collection("", obs_time);
  ObsInfo obs_info(xml_data, obs_pointing, gti_collection);
  
  size_t num_tels = 1;
  size_t xml_id = 0;
  size_t chip_id = 0;

  auto rmf_registry = std::make_shared<RmfRegistry>();
  Detector detector(xml_data, output_files, obs_info,
                    /*skip_invalids=*/true,
                    xml_id, chip_id,
                    rmf_registry);
  // Propagate readout until next event.
  
  SECTION("run detection") {
    //TODO: do tests for different carriers
    //Carrier test_carrier;
    //detector.runDetection(test_carrier);
    //TODO: decide on what to test here
  }
  
  SECTION("postprocessing") {
    std::string filename = "data/instruments/dummy/attitude_lissajous.fits";
    double dt = 1;
    NewAttitude attitude(filename, dt);
    
    detector.postprocessing(attitude, gti_collection);
  }
  
  SECTION("absorb") {
    SixtePhoton src_photon_1(0, 1.29, std::make_pair(0, 0), PhotonMetainfo(1, 1));
    SixtePhoton src_photon_2(0, 5.56, std::make_pair(0, 0), PhotonMetainfo(2, 1));
    SixtePhoton src_photon_3(0, 7.91, std::make_pair(0.0333*M_PI/180., 0.0333*M_PI/180.), PhotonMetainfo(3, 1));
    std::vector<SixtePhoton> src_photon_vec{src_photon_1, src_photon_2, src_photon_3};
    
    for (auto& photon : src_photon_vec) detector.absorb(photon);
  }
  
  SECTION("Pointer") {
    detector.sensorGeometry();
    detector.absorberGeometry();
  }
  
}
