/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "Carrier.h"

using namespace sixte;

TEST_CASE("Carrier Test", "[carrier]") {
  double energy;
  SixtePoint position;
  long ph_id = 324;
  long src_id = 2;
  PhotonMetainfo photon_metainfo(ph_id, src_id);
  double creation_time;

  EnergyDeposition energy_deposition(energy, position, photon_metainfo, creation_time);
  double sigma;
  
  std::string xml_filename = "data/instruments/dummy/default_extended.xml";
  pugi::xml_document xml_file;
  xml_file.load_file(xml_filename.c_str());
  XMLData xml_data(xml_file, "data/instruments/dummy/");
  
  Geometry absorber_geometry(0.,0.,0.);
  EnergyDepositions energy_depositions;
  
  
  SECTION("GaussianCCSimple") {
    GaussianCCSimple gaussian_cc_simple(energy_deposition, sigma, creation_time);
    
    BoundingBox2d test_box = gaussian_cc_simple.bounding_box();
    double test_charge = gaussian_cc_simple.charge(test_box);
    PhotonMetainfo test_metainfo = gaussian_cc_simple.photon_metainfo();
    double test_creation_time = gaussian_cc_simple.creationTime();
    
    //TODO: test_results
//    BoundingBox2d test_box_res = ;
//    double test_charge_res = ;
//    PhotonMetainfo test_metainfo_res = ;
//    double test_creation_time_res = ;
//
//    REQUIRE(test_box.top_right() == test_box_res.top_right());
//    REQUIRE(test_box.bottom_left() == test_box_res.bottom_left());
//    REQUIRE(test_box.center() == test_box_res.center());
//
//    REQUIRE_THAT(test_charge, Catch::Matchers::WithinAbs(test_charge_res, 1e-09));
//
//    REQUIRE(test_metainfo.ph_id_ == test_metainfo_res.ph_id_);
//    REQUIRE(test_metainfo.src_id_ == test_metainfo_res.src_id_);
//    REQUIRE(test_metainfo.tel_id_ == test_metainfo_res.tel_id_);
//
//    REQUIRE_THAT(test_creation_time, Catch::Matchers::WithinAbs(test_creation_time_res, 1e-09));
  }
  
  SECTION("ChargePoint") {
    ChargePoint charge_point(energy_deposition);
    ChargePoint charge_point_1;
    
    BoundingBox2d test_box = charge_point.bounding_box();
    double test_charge = charge_point.charge(test_box);
    PhotonMetainfo test_metainfo = charge_point.photon_metainfo();
    double test_creation_time = charge_point.creationTime();
    
    //TODO: test_results
//    BoundingBox2d test_box_res = ;
//    double test_charge_res = ;
//    PhotonMetainfo test_metainfo_res = ;
//    double test_creation_time_res = ;
//
//    REQUIRE(test_box.top_right() == test_box_res.top_right());
//    REQUIRE(test_box.bottom_left() == test_box_res.bottom_left());
//    REQUIRE(test_box.center() == test_box_res.center());
//
//    REQUIRE_THAT(test_charge, Catch::Matchers::WithinAbs(test_charge_res, 1e-09));
//
//    REQUIRE(test_metainfo.ph_id_ == test_metainfo_res.ph_id_);
//    REQUIRE(test_metainfo.src_id_ == test_metainfo_res.src_id_);
//    REQUIRE(test_metainfo.tel_id_ == test_metainfo_res.tel_id_);
//
//    REQUIRE_THAT(test_creation_time, Catch::Matchers::WithinAbs(test_creation_time_res, 1e-09));
  }
  
  SECTION("ExponentialCC") {}
  
  SECTION("GaussianCCPhys") {}
  
  SECTION("HeatPulse") {
    HeatPulse heat_pulse(energy_deposition, creation_time);

    BoundingBox2d test_box = heat_pulse.bounding_box();
    double test_charge = heat_pulse.charge(test_box);
    PhotonMetainfo test_metainfo = heat_pulse.photon_metainfo();
    double test_creation_time = heat_pulse.creationTime();
    
    //TODO: test_results
//    BoundingBox2d test_box_res = ;
//    double test_charge_res = ;
//    PhotonMetainfo test_metainfo_res = ;
//    double test_creation_time_res = ;
//
//    REQUIRE(test_box.top_right() == test_box_res.top_right());
//    REQUIRE(test_box.bottom_left() == test_box_res.bottom_left());
//    REQUIRE(test_box.center() == test_box_res.center());
//
//    REQUIRE_THAT(test_charge, Catch::Matchers::WithinAbs(test_charge_res, 1e-09));
//
//    REQUIRE(test_metainfo.ph_id_ == test_metainfo_res.ph_id_);
//    REQUIRE(test_metainfo.src_id_ == test_metainfo_res.src_id_);
//    REQUIRE(test_metainfo.tel_id_ == test_metainfo_res.tel_id_);
//
//    REQUIRE_THAT(test_creation_time, Catch::Matchers::WithinAbs(test_creation_time_res, 1e-09));
  }
  
  SECTION("ElectronTrack") {}
  
  SECTION("GaussianSimple") {
    GaussianSimple gaussian_simple(xml_data);
//    Carriers test_carriers = gaussian_simple.createCarriers(absorber_geometry, energy_depositions);
    
    //TODO: test_results
//    Carriers test_carriers_res = ;
//
//    REQUIRE(test_carriers.size() == test_carriers_res.size());
//    REQUIRE(test_carriers.begin() == test_carriers_res.begin());
//    REQUIRE(test_carriers.end() == test_carriers_res.end());
  }
  
  SECTION("ChargePointFactory") {
    ChargePointFactory charge_point_factory;
//    Carriers test_carriers = charge_point_factory.createCarriers(absorber_geometry, energy_depositions);
    
    //TODO: test_results
//    Carriers test_carriers_res = ;
//
//    REQUIRE(test_carriers.size() == test_carriers_res.size());
//    REQUIRE(test_carriers.begin() == test_carriers_res.begin());
//    REQUIRE(test_carriers.end() == test_carriers_res.end());
  }
  
  SECTION("HeatPulseSimple") {
    HeatPulseSimple heat_pulse_simple;
//    Carriers test_carriers = heat_pulse_simple.createCarriers(absorber_geometry, energy_depositions);
    
    //TODO: test_results
//    Carriers test_carriers_res = ;
//
//    REQUIRE(test_carriers.size() == test_carriers_res.size());
//    REQUIRE(test_carriers.begin() == test_carriers_res.begin());
//    REQUIRE(test_carriers.end() == test_carriers_res.end());
  }

}
