/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "CalibrationSource.h"

using namespace sixte;

TEST_CASE("Calibration Source Test", "[cal_source]") {
  std::string xml_filename = "data/instruments/dummy/default_extended.xml";
  pugi::xml_document xml_file;
  xml_file.load_file(xml_filename.c_str());
  XMLData xml_data(xml_file, "data/instruments/dummy/");
  
  std::shared_ptr<ArrayGeometry> absorber_array_geometry;
  
  std::pair<double, double> dt(3.2, 5.8);
  
  ModulatedXraySource modulated_xray_source (xml_data, absorber_array_geometry);
  
  SECTION("Get Next Photon") {
    std::optional<SixtePhoton> test_photon = modulated_xray_source.getNextPhoton(dt);
    
    //test_energy = ;
    //test_ra = ;
    //test_dec = ;
    
    //REQUIRE_THAT(test_photon->energy(), Catch::Matchers::WithinAbs(test_energy, 1e-09));
    //REQUIRE_THAT(test_photon->ra(), Catch::Matchers::WithinAbs(test_ra, 1e-09));
    //REQUIRE_THAT(test_photon->dec(), Catch::Matchers::WithinAbs(test_dec, 1e-09));
  }
}