/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include <catch2/catch_test_macros.hpp>

#include "Cache.h"

using namespace sixte;

TEST_CASE("Cache Test", "[cache]") {
  size_t max_size = 43;
  double x = 6.3;
  double val = 68.7;
  std::pair<double, double> pair(8.0, 6.7);
  
  Cache cache_1;

  Cache cache_2(max_size);
  
  SECTION("Contains") {
    bool containing_1 = cache_1.contains(x, val);
    bool containing_2 = cache_2.contains(x, val);
    
    //bool containing_1_test = ;
    //bool containing_2_test = ;
    
    //REQUIRE(containing_1 == containing_1_test);
    //REQUIRE(containing_2 == containing_2_test);
  }
  
  SECTION("Add") {
    cache_1.add(pair);
    cache_2.add(pair);
  }
  
}