/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/
#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "BoundingBox.h"

#include "Polygon.h"

using namespace sixte;

TEST_CASE("Bounding Box Test", "[bounding_box]") {
  Point_2 bottom_left(4,5);
  Point_2 top_right(8,93.23);
  Point_2 center_pos(8.2, 2.324);
  double edge_length = 9.75932;
  Point_2 test_point(3.43, 5.23);
  Vector_2 test_vec;
  
  BoundingBox2d bounding_box_default;
  BoundingBox2d bounding_box_1(bottom_left, top_right);
  BoundingBox2d bounding_box_2(center_pos, edge_length);
  
  Rectangle2d bounding_box_rec_default;
  Rectangle2d bounding_box_rec_1(bottom_left, top_right);
  Rectangle2d bounding_box_rec_2(center_pos, edge_length);
  
  SECTION("Bounding Box Geometry") {
    
    Point_2 test_bottom_left = bounding_box_1.bottom_left();
    Point_2 test_bottom_right = bounding_box_1.bottom_right();
    Point_2 test_top_left = bounding_box_1.top_left();
    Point_2 test_top_right = bounding_box_1.top_right();
    Point_2 test_center = bounding_box_1.center();
    double test_height = bounding_box_1.height();
    double test_width = bounding_box_1.width();
    
    Point_2 test_res_bottom_left;
    Point_2 test_res_bottom_right;
    Point_2 test_res_top_left;
    Point_2 test_res_top_right;
    Point_2 test_res_center;
    double test_res_height;
    double test_res_width;
  }
  
  SECTION("Overlap Check") {
    bool test_doOverlap = bounding_box_1.doOverlap(bounding_box_2);
  }
  
  SECTION("Contains Point") {
    bool test_containsPoint = bounding_box_1.containsPoint(test_point);
  }
  
  SECTION("Translation") {
    BoundingBox test_translation = translate(bounding_box_1, test_vec);
  }
}
