/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2024 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "ArrayGeometry.h"

#include "test_photon.h"

using namespace sixte;

TEST_CASE("Array Geometry Test", "[array_geometry]") {
  /** loading necessary files **/
  auto xml_filename_wfi = "data/instruments/athena-wfi/ld_wfi_ff_large_all_chips.xml";
  auto xml_filename_xifu = "data/instruments/athena-xifu/xifu_nofilt_infoc_20240326.xml";
  
  pugi::xml_document xml_file_wfi;
  xml_file_wfi.load_file(xml_filename_wfi);
  XMLData xml_data_wfi(xml_file_wfi, "data/instruments/athena-wfi/");
  
  pugi::xml_document xml_file_xifu;
  xml_file_xifu.load_file(xml_filename_xifu);
  XMLData xml_data_xifu(xml_file_xifu, "data/instruments/athena-wfi/");
  
  NewAttitude new_attitude("data/instruments/dummy/attitude_lissajous.fits", 10);
  
  
  /** initialising test class **/
  std::unique_ptr<ArrayGeometry> array_geometry_wfi = createGeometry(xml_data_wfi);
  Geometry absorber_geometry_wfi(xml_data_wfi);
  
  std::unique_ptr<ArrayGeometry> array_geometry_xifu = createGeometry(xml_data_xifu);
  Geometry absorber_geometry_xifu(xml_data_xifu);
  
  RectangularArray rectangular_array(xml_data_wfi);
  FreeGeometry free_geometry(xml_data_xifu);
  
  
  SECTION("Get PixelID") {
    /** test values: */
    Point_2 position{0.001,0.001};
    T_PixId ref_test_getPixId_rec = 134919; // TODO: values taken from cpp code, need recalculation
    T_PixId ref_test_getPixId_free = 119; // TODO: values taken from cpp code, need recalculation
    
    /** function to be tested: */
    std::optional<T_PixId> test_getPixId_rec = rectangular_array.getPixId(position);
    std::optional<T_PixId> test_getPixId_free = free_geometry.getPixId(position);
    
    /** test: */
    REQUIRE(test_getPixId_rec == ref_test_getPixId_rec);
    REQUIRE(test_getPixId_free == ref_test_getPixId_free);
  }
  
  SECTION("Get PixelIDs") {
    /** test values: */
    Point_2 bottom_left(-100,-100);
    Point_2 top_right(100,100);
    BoundingBox2d bounding_box(bottom_left, top_right);
    
    std::vector<T_PixId> ref_test_getPixIds_rec; //TODO: test_value
    std::vector<T_PixId> ref_test_getPixIds_free; //TODO: test_value
    
    /** function to be tested: */
    std::vector<T_PixId> test_getPixIds_rec = rectangular_array.getPixIds(bounding_box);
    std::vector<T_PixId> test_getPixIds_free = free_geometry.getPixIds(bounding_box);
    
    /** test: */
//    REQUIRE(test_getPixIds_rec == ref_test_getPixIds_rec);
//    REQUIRE(test_getPixIds_free == ref_test_getPixIds_free);
  }
  
  SECTION("XY to PixelID") {
    /** test values: */
    size_t xi = 3;
    size_t yi = 4;
    T_PixId ref_test_xy2pixid; //TODO: test_value
    
    /** function to be tested: */
    T_PixId test_xy2pixid = rectangular_array.xy2PixId(xi, yi);
    
    /** test: */
//    REQUIRE(test_xy2pixid == ref_test_xy2pixid);
  }
  
  SECTION("PixelID to XY") {
    /** test values: */
    size_t pix_id = 2381;
    std::pair<unsigned int, unsigned int> ref_test_PixId2xy; //TODO: test_value
    
    /** function to be tested: */
    std::pair<unsigned int, unsigned int> test_PixId2xy = rectangular_array.PixId2xy(pix_id);
    
    /** test: */
//    REQUIRE(test_PixId2xy.first == ref_test_PixId2xy.first);
//    REQUIRE(test_PixId2xy.second == ref_test_PixId2xy.second);
  }
  
//  SECTION("Get Random PixelID") {
//    /** test values: */
//    T_PixId ref_test_getRandomPixId_rec; //TODO: test_value
//    T_PixId ref_test_getRandomPixId_free; //TODO: test_value
//
//    /** function to be tested: */
//    T_PixId test_getRandomPixId_rec = rectangular_array.getRandomPixId();
//    T_PixId test_getRandomPixId_free = free_geometry.getRandomPixId();
//
//    /** test: */
////    REQUIRE(test_getRandomPixId_rec == ref_test_getRandomPixId_rec);
////    REQUIRE(test_getRandomPixId_free == ref_test_getRandomPixId_free);
//  }
  
//  SECTION("Get Random Position in Pixel") {
//    /** test values: */
//    size_t pix_id = 2381;
//    std::pair<double,double> ref_test_getRandPosInPixel_rec; //TODO: test_value
//    std::pair<double,double> ref_test_getRandPosInPixel_free; //TODO: test_value
//
//    /** function to be tested: */
//    std::pair<double,double> test_getRandPosInPixel_rec = rectangular_array.getRandPosInPixel(pix_id);
//    std::pair<double,double> test_getRandPosInPixel_free = free_geometry.getRandPosInPixel(pix_id);
//
//    /** test: */
////    REQUIRE(test_getRandPosInPixel_rec.first == ref_test_getRandPosInPixel_rec.first);
////    REQUIRE(test_getRandPosInPixel_rec.second == ref_test_getRandPosInPixel_rec.second);
////    REQUIRE(test_getRandPosInPixel_free.first == ref_test_getRandPosInPixel_free.first);
////    REQUIRE(test_getRandPosInPixel_free.second == ref_test_getRandPosInPixel_free.second);
//  }
//
//  SECTION("Total Surface Area") {
//    /** test values: */
//    double ref_test_totalSurfaceArea_rec; //TODO: test_value
//    double ref_test_totalSurfaceArea_free; //TODO: test_value
//
//    /** function to be tested: */
//    double test_totalSurfaceArea_rec = rectangular_array.totalSurfaceArea();
//    double test_totalSurfaceArea_free = free_geometry.totalSurfaceArea();
//
//    /** test: */
////    REQUIRE_THAT(test_totalSurfaceArea_rec, Catch::Matchers::WithinAbs(ref_test_totalSurfaceArea_rec, 1e-9));
////    REQUIRE_THAT(test_totalSurfaceArea_free, Catch::Matchers::WithinAbs(ref_test_totalSurfaceArea_free, 1e-9));
//  }
//
//  SECTION("Get Polygon") {
//    /** test values: */
//    size_t pix_id = 2381;
//    Rectangle2d ref_test_getPolygon_rec; //TODO: test_value
//    Rectangle2d ref_test_getPolygon_free; //TODO: test_value
//
//    /** function to be tested: */
//    Rectangle2d test_getPolygon_rec = rectangular_array.getPolygon(pix_id);
//    Rectangle2d test_getPolygon_free = free_geometry.getPolygon(pix_id);
//
//    /** test: */
////    REQUIRE(test_getPolygon_rec.top_right() == ref_test_getPolygon_rec.top_right());
////    REQUIRE(test_getPolygon_rec.bottom_left() == ref_test_getPolygon_rec.bottom_left());
////    REQUIRE(test_getPolygon_rec.center() == ref_test_getPolygon_rec.center());
////    REQUIRE(test_getPolygon_free.top_right() == ref_test_getPolygon_free.top_right());
////    REQUIRE(test_getPolygon_free.bottom_left() == ref_test_getPolygon_free.bottom_left());
////    REQUIRE(test_getPolygon_free.center() == ref_test_getPolygon_free.center());
//  }
  
  SECTION("Get Number of Pixels") {
    /** test values: */
    size_t ref_test_numpix_rec; //TODO: test_value
    size_t ref_test_numpix_free; //TODO: test_value
    
    /** function to be tested: */
    size_t test_numpix_rec = rectangular_array.numpix();
    size_t test_numpix_free = free_geometry.numpix();
    
    /** test: */
//    REQUIRE(test_numpix_rec == ref_test_numpix_rec);
//    REQUIRE(test_numpix_free == ref_test_numpix_free);
  }
  
  SECTION("Get X Width") {
    /** test values: */
    int ref_test_getXWidth; //TODO: test_value
    
    /** function to be tested: */
    int test_getXWidth = rectangular_array.getXWidth();
    
    /** test: */
//    REQUIRE(test_getXWidth == ref_test_getXWidth);
  }
  
  SECTION("Get Y Width") {
    /** test values: */
    int ref_test_getYWidth_rec; //TODO: test_value
    
    /** function to be tested: */
    int test_getYWidth_ref = rectangular_array.getYWidth();
    
    /** test: */
//    REQUIRE(test_getYWidth_ref == ref_test_getYWidth_rec);
  }
  
  SECTION("Do Photon Projection") {
    /** test values: */
    
    /** function to be tested: */
//    rectangular_array.doPhotonProjection(new_attitude, absorber_geometry, focal_length, fptr, tstart, tstop);
//    free_geometry.doPhotonProjection(new_attitude, absorber_geometry, focal_length, fptr, tstart, tstop);
    
    /** test: */
  }
  
  
  SECTION("Detector To Sky Coordinates") {
    /** test values: */
    std::pair<double,double> test_res_det_to_sky; //TODO: test_value
    
    /** function to be tested: */
//    std::pair<double,double> test_det_to_sky = detToSky(detx, dety, focal_length, time, new_attitude, absorber_geometry);
    
    /** test: */
//    REQUIRE_THAT(test_det_to_sky.first, Catch::Matchers::WithinAbs(test_res_det_to_sky.first, 1e-09));
//    REQUIRE_THAT(test_det_to_sky.second, Catch::Matchers::WithinAbs(test_res_det_to_sky.second, 1e-09));
  }
  
  SECTION("Remove Overlap") {
    /** test values: */
    std::vector<Rectangle2d> pixels; //TODO: test_value
    std::vector<Rectangle2d> ref_test_vec_rec2d; //TODO: test_value
    
    /** function to be tested: */
    std::vector<Rectangle2d> test_vec_rec2d = removeOverlaps(pixels);
    
    /** test: */
//    REQUIRE(test_vec_rec2d.size() == ref_test_vec_rec2d.size());
//    for (size_t test_index=0; test_index<=test_vec_rec2d.size(); test_index++) {
//      REQUIRE(test_vec_rec2d[test_index].top_right() == ref_test_vec_rec2d[test_index].top_right());
//      REQUIRE(test_vec_rec2d[test_index].bottom_left() == ref_test_vec_rec2d[test_index].bottom_left());
//      REQUIRE(test_vec_rec2d[test_index].center() == ref_test_vec_rec2d[test_index].center());
//    }
  }
}
