#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>

#include "Carrier.h"

using namespace sixte;

TEST_CASE("Carrier Test", "[carrier]") {
  auto e_dep = 7.;
  SixtePoint pos(0, 0, 0);
  PhotonMetainfo photon_metainfo(0, 0);
  auto creation_time = 0.;

  EnergyDeposition energy_deposition(e_dep, pos, photon_metainfo, creation_time);

  SECTION("GaussianCCSimple") {
    auto sigma = 10.e-6;
    GaussianCCSimple gaussian_cc_simple(energy_deposition, sigma, creation_time);

    BoundingBox2d bbox(Point_2(pos.x(), pos.y()), 1);
    REQUIRE_THAT(gaussian_cc_simple.charge(bbox), Catch::Matchers::WithinAbs(e_dep, 1e-9));
  }
}
