#!/bin/bash
set -e

# E2E test for Jupiter with eROSITA
# Setup: erass2 attitude, with background, all TMs
# Output: merged event file, image, spectrum of pole

# NOTE: running this script with the option -r runs it in reference mode,
# generating new reference data

# Reference simulation done with
# * Tool: sixtesim
# * SIXTE 3.2.0, commit 29e9f9a8185
# * SIMPUT 2.7.1, commit 4a44dc02ae9
# * srg instruments v1.9.2, commit aa4b85faf

### Setup
. ./data/scripts/setup/setup_e2e.sh

# Simulation parameters
xml_dir=${SIXTE_TESTDATA}/instruments/srg/erosita/
base=jupiter_sixtesim
attitude=${simput_dir}/jupiter/attitude_erass2.fits
gtifile=${simput_dir}/jupiter/gti_erass2.fits
RA=230.170211791992
Dec=-57.166690826416
Seed=-1
###

# get mode in which we're running
refmode=0
while getopts ":r" arg
do
  case "$arg" in
    r)
      refmode=1
  esac
done

if [ $refmode == 1 ]
then
  echo "Running in reference mode"
  base=jupiter_sixtesim_ref
  Seed=1
else
  echo "Running in test mode"
fi

mkdir -p ${output_dir}

### Simulation
$SIXTE/bin/sixtesim \
  Attitude=${attitude} \
  GTIFile=${gtifile} \
  Exposure=1 \
  MJDREF=51543.875 \
  XMLFile="${xml_dir}/erosita_1.xml,${xml_dir}/erosita_2.xml,${xml_dir}/erosita_3.xml,${xml_dir}/erosita_4.xml,${xml_dir}/erosita_5.xml,${xml_dir}/erosita_6.xml,${xml_dir}/erosita_7.xml" \
  Prefix=${output_dir} \
  Simput=${simput_dir}/jupiter/jupiter_hiflux.simput \
  EvtFile=evt_${base}.fits \
  PhotonList=ph_${base}.fits \
  ImpactList=imp_${base}.fits \
  RawData=raw_${base}.fits \
  Background=y \
  clobber=y \
  chatter=3 \
  Seed=${Seed}


### Anaylsis
. ./analysis.sh


printf "\n%s executed successfully\n" "${0}"
exit 0
