#!/bin/bash
set -e

ftmerge \
  infile=${output_dir}/tel1_evt_${base}.fits,${output_dir}/tel2_evt_${base}.fits,${output_dir}/tel3_evt_${base}.fits,${output_dir}/tel4_evt_${base}.fits,${output_dir}/tel5_evt_${base}.fits,${output_dir}/tel6_evt_${base}.fits,${output_dir}/tel7_evt_${base}.fits \
  outfile=${output_dir}/evt_${base}.fits clobber=y

$SIXTE/bin/imgev \
  EvtFile=${output_dir}/evt_${base}.fits \
  Image=${output_dir}/img_${base}.fits \
  CoordinateSystem=0 Projection=TAN \
  CUNIT1=deg CUNIT2=deg \
  NAXIS1=384 NAXIS2=384 \
  CRVAL1=${RA} CRVAL2=${Dec} \
  CDELT1=-0.0027778 CDELT2=0.00277778 \
  CRPIX1=192.5 CRPIX2=192.5 \
  clobber=yes

$SIXTE/bin/radec2xy \
  EvtFile=${output_dir}/evt_${base}.fits \
  Projection=TAN \
  RefRA=${RA} RefDec=${Dec}

$SIXTE/bin/makespec \
  EvtFile=${output_dir}/evt_${base}.fits \
  Spectrum=${output_dir}/spec_${base}.pha \
  EventFilter="regfilter(\"source.reg\")" \
  RSPPath=${xml_dir} \
  clobber=y


# Delete all events to reduce file sizes, but keep total number as header key in
# merged event file.
num_events=$(ftkeypar ${output_dir}/evt_${base}.fits[1] NAXIS2 chatter=3 | grep 'value:' | awk '{print $2}')
ftdelrow \
  infile=${output_dir}/evt_${base}.fits[1] \
  outfile=${output_dir}/evt_${base}_header_only.fits \
  rows=1- clobber=yes
fparkey \
  value=${num_events} \
  fitsfile=${output_dir}/evt_${base}_header_only.fits[1] \
  keyword=NEVENTS add=yes

for ii in {1..7}
do
  ftdelrow \
    infile=${output_dir}/tel${ii}_evt_${base}.fits[1] \
    outfile=${output_dir}/tel${ii}_evt_${base}_header_only.fits \
    rows=1- clobber=yes
done
