#!/bin/bash
set -e

# E2E test for point sources with Crab-like spectra with Athena WFI
# Setup: 1ks, with background, two point sources (mcrab and 10mcrab), full LDA
# Output: merged event file, image, spectrum of 10 mcrab source

# NOTE: running this script with the option -r runs it in reference mode,
# generating new reference data

# Reference simulation done with
# * Tool: sixtesim
# * SIXTE 3.2.0, commit 29e9f9a8185
# * SIMPUT 2.7.1, commit 4a44dc02ae9
# * athena-wfi instruments v1.11.1, commit 753ac20c

### Setup
. ./data/scripts/setup/setup_e2e.sh

# Simulation parameters
xml_dir=${SIXTE_TESTDATA}/instruments/athena-wfi/wfi_wo_filter/
base=crab_sixtesim
RA=0.166
Dec=0.166
exposure=1000
Seed=-1
###

# get mode in which we're running
refmode=0
while getopts ":r" arg
do
  case "$arg" in
    r)
      refmode=1
  esac
done

if [ $refmode == 1 ]
then
  echo "Running in reference mode"
  base=crab_sixtesim_ref
  Seed=1
else
  echo "Running in test mode"
fi

mkdir -p ${output_dir}

### Simulation
$SIXTE/bin/sixtesim \
  XMLFile=${xml_dir}/ld_wfi_ff_all_chips.xml \
  RA=${RA} Dec=${Dec} \
  Exposure=${exposure} \
  Prefix=${output_dir} \
  Simput="${simput_dir}/crab/mcrab_RA0.00Dec0.00.fits,${simput_dir}/crab/10mcrab_RA0.33Dec0.00.fits" \
  EvtFile=evt_${base}.fits \
  PhotonList=ph_${base}.fits \
  ImpactList=imp_${base}.fits \
  RawData=raw_${base}.fits \
  Background=y \
  clobber=y \
  progressbar=y \
  chatter=3 \
  Seed=${Seed}


### Anaylsis
. ../athena-wfi_cdfs/analysis.sh


printf "\n%s executed successfully\n" "${0}"
exit 0
