#!/bin/bash
set -e

# E2E test for CDFS with Athena WFI
# Setup: 8ks, with background, with dithering, full LDA
# Output: merged event file, image, spectrum of one source

# NOTE: running this script with the option -r runs it in reference mode,
# generating new reference data

# Reference simulation done with
# * Tool: sixtesim
# * SIXTE 3.2.0, commit 29e9f9a8185
# * SIMPUT 2.7.1, commit 4a44dc02ae9
# * athena-wfi instruments v1.11.1, commit 753ac20c

### Setup
. ./data/scripts/setup/setup_e2e.sh

# Simulation parameters
xml_dir=${SIXTE_TESTDATA}/instruments/athena-wfi/wfi_wo_filter/
base=cdfs_sixtesim
RA=53.13
Dec=-27.8
exposure=8000
Seed=-1
###

# get mode in which we're running
refmode=0
while getopts ":r" arg
do
  case "$arg" in
    r)
      refmode=1
  esac
done

if [ $refmode == 1 ]
then
  echo "Running in reference mode"
  base=cdfs_sixtesim_ref
  Seed=1
else
  echo "Running in test mode"
fi

mkdir -p ${output_dir}

### Simulation
$SIXTE/bin/attgen_dither \
  Attitude=${output_dir}/attitude_lissajous.fits \
  Amplitude=0.035 \
  SrcRA=${RA} SrcDec=${Dec} \
  Exposure=${exposure} \
  clobber=y

$SIXTE/bin/sixtesim \
  XMLFile=${xml_dir}/ld_wfi_ff_all_chips.xml \
  Attitude=${output_dir}/attitude_lissajous.fits \
  Exposure=${exposure} \
  Prefix=${output_dir} \
  Simput="${simput_dir}/CDFS_combined_simput/CDFS_cat_lehmer.fits,${simput_dir}/CDFS_combined_simput/CDFS_cat_galaxies.fits" \
  EvtFile=evt_${base}.fits \
  PhotonList=ph_${base}.fits \
  ImpactList=imp_${base}.fits \
  RawData=raw_${base}.fits \
  Background=y \
  clobber=y \
  progressbar=y \
  chatter=3 \
  Seed=${Seed}


### Anaylsis
. ./analysis.sh


printf "\n%s executed successfully\n" "${0}"
exit 0
