#!/bin/bash
set -e

ftmerge \
  infile=${output_dir}/chip0_evt_${base}.fits,${output_dir}/chip1_evt_${base}.fits,${output_dir}/chip2_evt_${base}.fits,${output_dir}/chip3_evt_${base}.fits \
  outfile=${output_dir}/evt_${base}.fits clobber=y

$SIXTE/bin/imgev \
  EvtFile=${output_dir}/evt_${base}.fits \
  Image=${output_dir}/img_${base}.fits \
  CoordinateSystem=0 Projection=TAN \
  NAXIS1=1063 NAXIS2=1063 CUNIT1=deg CUNIT2=deg \
  CRVAL1=${RA} CRVAL2=${Dec} CRPIX1=532 CRPIX2=532 \
  CDELT1=-6.207043e-04 CDELT2=6.207043e-04 history=true \
  clobber=yes

$SIXTE/bin/radec2xy \
  EvtFile=${output_dir}/evt_${base}.fits \
  Projection=TAN \
  RefRA=${RA} RefDec=${Dec}

$SIXTE/bin/makespec \
  EvtFile=${output_dir}/evt_${base}.fits \
  Spectrum=${output_dir}/spec_${base}.pha \
  EventFilter="regfilter(\"source.reg\")" \
  RSPPath=${xml_dir} \
  clobber=y

# Delete all events to reduce file sizes, but keep total number as header key in
# merged event file.
num_events=$(ftkeypar ${output_dir}/evt_${base}.fits[1] NAXIS2 chatter=3 | grep 'value:' | awk '{print $2}')
ftdelrow \
  infile=${output_dir}/evt_${base}.fits[1] \
  outfile=${output_dir}/evt_${base}_header_only.fits \
  rows=1- clobber=yes
fparkey \
  value=${num_events} \
  fitsfile=${output_dir}/evt_${base}_header_only.fits[1] \
  keyword=NEVENTS add=yes

for ii in {0..3}
do
  ftdelrow \
    infile=${output_dir}/chip${ii}_evt_${base}.fits[1] \
    outfile=${output_dir}/chip${ii}_evt_${base}_header_only.fits \
    rows=1- clobber=yes
done
