/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "sixte_random.h"
#include "SixteException.h"

extern "C" {
#include "sixt.h"
}

namespace sixte {

void initSixteRng(int rng_seed) {
  int status = EXIT_SUCCESS;
  unsigned int seed = getSeed(rng_seed);
  std::cout << "Seed = " << seed << std::endl;
  sixt_init_rng(seed, &status);
  checkStatusThrow(status, "Failed to initialize Sixte RNG");

  poisson_gsl_pointer = std::make_unique<PoissonGSLRng>(seed);
}

double getGaussRandomNumber() {
  double ret_val, dummy_val;

  int status = EXIT_SUCCESS;
  sixt_get_gauss_random_numbers(&ret_val, &dummy_val, &status);
  checkStatusThrow(status, "Failed to generate Gaussian random number");

  return ret_val;
}

double getUniformRandomNumber(){
  int status = EXIT_SUCCESS;
  double ret_val = sixt_get_random_number(&status);
  checkStatusThrow(status, "Failed to generate uniform random number");

  return ret_val;
}

std::unique_ptr<PoissonGSLRng> poisson_gsl_pointer;

size_t getPoissonGSLRngNumber(double weight) {
  return poisson_gsl_pointer->getPoissonGSLRngNumber(weight);
}

double getFlatGSLRngNumber(double a, double b) {
  return poisson_gsl_pointer->getFlatGSLRngNumber(a, b);
}

}
