/*
This file is part of SIXTE.
   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.
   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.
   Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include <string>
#include "SixteLinterp.h"
#include "SixteVector.h"

namespace sixte {
namespace PhysicalConstants {
constexpr double H = 4.1356692E-15;     // eV s
constexpr double C = 299792458.0;       // m/s
constexpr double R_E = 2.8179403E-15;   // m
constexpr double N_A = 6.02214129E+23;  // mol^-1
}  // namespace PhysicalConstants

class SurfaceElement {
public:
    SurfaceElement();
    SurfaceElement(std::string  database_path,
                   std::string  element_name);

    // 1) Copy constructor
    SurfaceElement(const SurfaceElement& other);
    // 2) Copy assignment
    SurfaceElement& operator=(const SurfaceElement& other);
    // 3) Move constructor
    SurfaceElement(SurfaceElement&&) noexcept = default;
    // 4) Move assignment
    SurfaceElement& operator=(SurfaceElement&&) noexcept = default;
    // 5) Destructor
    ~SurfaceElement() = default;

    [[nodiscard]] double reflectivity(double energy, double angle) const;

    [[nodiscard]] bool doesReflect(double energy, double angle) const;

    private:
    std::string database_path_;
    std::string element_name_;
    std::vector<double> f1_list_;
    std::vector<double> f2_list_;
    std::vector<double> energy_grid_;
    double density_{};
    double mass_{};

    std::optional<linterp::InterpMultilinear<1, double>> interp_ML_f1_;
    std::optional<linterp::InterpMultilinear<1, double>> interp_ML_f2_;
};
}  // namespace sixte