/*
    This file is part of SIXTE.

    SIXTE is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    SIXTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License see
    <http://www.gnu.org/licenses/>.


    Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
    Erlangen-Nuernberg
*/

#pragma once
/**
 * From Paper: Microfacet Models for Refraction through Rough Surfaces by Walter et al. (2007)
**/


#include "SurfaceStrategy.h"
#include "sixte_random.h"
#include "cmath"

class Microfacet final : public SurfaceStrategy {
public:
    explicit Microfacet() {};
    explicit Microfacet(double palpha, double palpha_shadowing, bool pggx, bool pggx_shadowing);
    ~Microfacet() override = default;
    bool simulate_surface(Ray & ray) const override;
    void set_surface_parameter(std::string model, std::string shadowing, double factor, double shadowing_factor) override;
private:

    Vec3fa get_beckmann_m() const;

    [[nodiscard]] double beckmann_shadowing_term(Vec3fa v, Vec3fa m) const ;

    [[nodiscard]] Vec3fa get_gxx_m() const;

    [[nodiscard]] double ggx_shadowing_term(const Vec3fa& v, const Vec3fa& m) const;

    static double positive_characteristic_function(double a) ;

    double alpha{};
    double alpha_shadowing{};
    bool ggx{};
    bool ggx_shadowing{};

};

