/*
    This file is part of SIXTE.

    SIXTE is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    SIXTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License see
    <http://www.gnu.org/licenses/>.


    Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
    Erlangen-Nuernberg
*/


#include "GaussSurface.h"


bool GaussSurface::simulate_surface(Ray &ray) const
{
    Vec3fa new_normal ={static_cast<float>(ray.normal().x + ray.normal().x * factor_ * sixte::getGaussRandomNumber()),
               static_cast<float>(ray.normal().y + ray.normal().y * factor_ * sixte::getGaussRandomNumber()),
               static_cast<float>(ray.normal().z + ray.normal().z * factor_ * sixte::getGaussRandomNumber())};
    ray.set_normal(new_normal);
    return true;
}

void
GaussSurface::set_surface_parameter(std::string model, std::string shadowing, double factor, double shadowing_factor) {

}
