/*
    This file is part of SIXTE.

    SIXTE is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    SIXTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License see
    <http://www.gnu.org/licenses/>.


    Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
    Erlangen-Nuernberg
*/

#pragma once

#include <memory>

#include "raytracing/geometry/Vec3fa.h"
#include "raytracing/geometry/Ray.h"
#include "Plane.h"
#include "sixte_random.h"
#include "raytracing/surface/Reflectivity.h"
#include "raytracing/surface/SurfaceModel.h"


class Pore {
public:
    Pore();

    Pore(double pwidth, double plength, Vec3fa protation, Vec3fa ptranslation,
         std::string material_path, std::string material,
         std::shared_ptr<SurfaceModel> surface_model);

    void set_rotation(Vec3fa protation);

    void set_translation(Vec3fa ptranslation);

    void set_width(double width);

    void set_length(double length);

    bool ray_trace(Ray &ray, int depth);

    double generateRandomDouble(double m, double n);


private:
    double width, length;
    Vec3fa rotation{};
    Vec3fa translation{};
    Plane wall1, wall2, wall3, wall4, floor;
    sixte::SurfaceElement coating;
    std::shared_ptr<SurfaceModel> surface_model_;


    int findInterection(Ray &ray);
    bool reflect_ray(Ray &ray);
};

