/*
    This file is part of SIXTE.

    SIXTE is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    SIXTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License see
    <http://www.gnu.org/licenses/>.


    Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
    Erlangen-Nuernberg
*/

#pragma once

#include "raytracing/geometry/Ray.h"
#include "raytracing/sensor/Sensor.h"
#include <embree4/rtcore.h>

struct Plane_parameters {
    double a, b, c, d, sensor_x, sensor_y;
    RTCGeometry geometry;
    unsigned int geomID;
};


class Plane {
public:
    //parameters for the plane ax + b+y + cz + d = 0
    double a_, b_, c_, d_, sensor_x_, sensor_y_;
    Plane_parameters planeParameters{};

    Plane();

    explicit Plane(double a, double b, double c, double d, double sensor_x, double sensor_y);

    static void planeBoundsFunc(const RTCBoundsFunctionArguments *args);

    static void planeIntersectFunc(const RTCIntersectFunctionNArguments *args);

    static void planeOccludedFunc(const RTCOccludedFunctionNArguments *args);

    bool isOnSensor(const RTCRayHit& rayHit) const;

    double planeIntersect(Ray &rayhit) const;

};
