/*
    This file is part of SIXTE.

    SIXTE is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    SIXTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License see
    <http://www.gnu.org/licenses/>.


    Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
    Erlangen-Nuernberg
*/

#pragma once

#if defined(RTC_NAMESPACE_USE)
RTC_NAMESPACE_USE
#endif

#include "raytracing/geometry/Ray.h"
#include "raytracing/surface/SurfaceModel.h"
#include "raytracing/surface/GaussSurface.h"
#include "raytracing/surface/Microfacet.h"
#include <embree4/rtcore.h>
#include <array>

struct Paraboloid_parameters {
    double p, theta, Yp_min, Xp_min, Xp_max, Yp_max;
    std::shared_ptr<SurfaceModel> surface;
    RTCGeometry geometry;
    unsigned int geomID;
    double angle_x, angle_y;
    Vec3fa origin = Vec3fa{0.f, 0.f, 0.f};
};

class Paraboloid {
    // class for paraboloid equation:
    // z = (x²+y²)/2p - p/2
public:
    double theta;
    double p;
    double Yp_min;
    double Xp_min;
    double Xp_max;
    double Yp_max;
    std::shared_ptr<SurfaceModel> surface;
    unsigned int geomID;
    Paraboloid_parameters paraboloid_parameters;

    explicit Paraboloid(Paraboloid_parameters paraboloid_parameters);

    static void paraboloidBoundsFunc(const RTCBoundsFunctionArguments *args);

    static void paraboloidIntersectFunc(const RTCIntersectFunctionNArguments *args);

    static void paraboloidOccludedFunc(const RTCOccludedFunctionNArguments *args);

};
