/*
    This file is part of SIXTE.

    SIXTE is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    SIXTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License see
    <http://www.gnu.org/licenses/>.


    Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
    Erlangen-Nuernberg
*/

#pragma once

#include "raytracing/geometry/Ray.h"
#include "raytracing/surface/SurfaceModel.h"
#include "raytracing/surface/GaussSurface.h"
#include <embree4/rtcore.h>

struct Hyperboloid_parameters {
    double a, b, c, Xh_max, Xh_min, Yh_max, Yh_min, theta;
    std::shared_ptr<SurfaceModel> surface;
    RTCGeometry geometry;
    unsigned int geomID;
    double angle_x, angle_y;
    Vec3fa origin = Vec3fa{0.f, 0.f, 0.f};
};


class Hyperboloid {
public:
    double a, b, c, Xh_max, Xh_min, Yh_max, Yh_min, theta;
    std::shared_ptr<SurfaceModel> surface;
    Hyperboloid_parameters hyperboloid_parameters{};
    unsigned int geomID;

    explicit Hyperboloid(Hyperboloid_parameters hyperboloid_parameters);

    static void hyperboloidBoundsFunc(const RTCBoundsFunctionArguments *args);

    static void hyperboloidIntersectFunc(const RTCIntersectFunctionNArguments *args);

    static void hyperboloidOccludedFunc(const RTCOccludedFunctionNArguments *args);
};

