/*
    This file is part of SIXTE.

    SIXTE is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    SIXTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License see
    <http://www.gnu.org/licenses/>.


    Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
    Erlangen-Nuernberg
*/

#pragma once

#include "raytracing/geometry/Ray.h"

class Sensor {
public:
  Sensor();
  Sensor(const std::string& file_name, const Vec3fa& position);

  [[nodiscard]] Vec2fa worldToSensor(const Ray &hit) const;
  [[nodiscard]] Vec3fa sensorToWorld(float x_val, float y_val) const;

  void setGeometricID(size_t geom_id);
  void setOriginPoint(const Vec3fa& origin_point);
  void setAxes(const Vec3fa& x_axis, const Vec3fa& y_axis);

  [[nodiscard]] std::string filename() const {
    return filename_;
  }

  [[nodiscard]] Vec3fa position() const {
    return position_;
  }

  [[nodiscard]] size_t geomID() const {
    return geomID_;
  }

 private:
  std::string filename_;
  Vec3fa position_;

  size_t geomID_ = -1;

  Vec3fa origin_point_;
  Vec3fa x_axis_;
  Vec3fa y_axis_;

};

