/*
    This file is part of SIXTE.

    SIXTE is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    SIXTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License see
    <http://www.gnu.org/licenses/>.


    Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
    Erlangen-Nuernberg
*/

#include "Sensor.h"

Sensor::Sensor() {
  filename_ = "";
  position_ = Vec3fa{0.f, 0.f, 0.f};
}

Sensor::Sensor(const std::string& file_name, const Vec3fa &position) {
  filename_ = file_name;
  Sensor::position_ = position;
}

void Sensor::setGeometricID(size_t geom_id) {
  geomID_ = geom_id;
}

void Sensor::setOriginPoint(const Vec3fa& origin_point) {
  origin_point_ = origin_point;
}

void Sensor::setAxes(const Vec3fa& x_axis, const Vec3fa& y_axis) {
  x_axis_ = x_axis;
  y_axis_ = y_axis;

  // TODO: implement check
//  if (cross(x_axis_, y_axis_) != Vec3fa(1, 1, 1)) {
//    throw std::runtime_error("Axes of Triangle not orthogonal");
//  }
}

Vec2fa Sensor::worldToSensor(const Ray &hit) const {
  //TODO: needed?
    Vec3fa ex = normalize(x_axis_ - origin_point_);     // x-axis direction on sensor
    Vec3fa tmp = y_axis_ - origin_point_;
    Vec3fa ey  = tmp - ex * dot(tmp, ex);             // Gram–Schmidt: remove x component
    ey = normalize(ey);
//    Vec3fa ez  = normalize(cross(ex, ey));            // plane normal (optional check)

    // 2) Project v onto that frame
    Vec3fa v = hit.position() - origin_point_;
    float x = dot(v, ex);
    float y = dot(v, ey);
    return {x, y};
}

Vec3fa Sensor::sensorToWorld(float x_val, float y_val) const {
  Vec3fa ex = normalize(x_axis_ - origin_point_);
  Vec3fa tmp = y_axis_ - origin_point_;
  Vec3fa ey  = normalize(tmp - ex * dot(tmp, ex));

  return origin_point_ + x_val * ex + y_val * ey;
}
