/*
    This file is part of SIXTE.

    SIXTE is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    SIXTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License see
    <http://www.gnu.org/licenses/>.


    Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
    Erlangen-Nuernberg
*/

#pragma once

//  Paper to be referenced for the math: "Geometries for Grazing Incidence Mirrors" by Pivovaroff et al. 2023
//  https://link.springer.com/10.1007/978-981-16-4544-0_2-1
//

#include "raytracing/mirror_module/MirrorModule.h"
#include "raytracing/shape/Paraboloid.h"
#include "raytracing/shape/Hyperboloid.h"
#include "raytracing/mirror_module/EmbreeScene.h"

#include "raytracing/shape/Shape.h"
#include "raytracing/surface/SurfaceModel.h"
#include "raytracing/surface/GaussSurface.h"
#include "raytracing/surface/Microfacet.h"
#include "raytracing/surface/Dummy.h"
#include "raytracing/sensor/Sensor.h"
#include "raytracing/shape/Plane.h"
#include "raytracing/shape/Spider.h"


class Wolter final : public virtual MirrorModule {
public:
    double outer_radius;
    double inner_radius;
    int number_of_shells;

    ~Wolter() override = default;

    explicit Wolter(const sixte::XMLData& xml_data);

    Wolter(const Wolter& o) = default;

    Wolter(Wolter&& o) noexcept = default;

    [[nodiscard]] std::unique_ptr<MirrorModule> clone() const override {
        return std::make_unique<Wolter>(*this);
    }
    std::optional<Ray> ray_trace(Ray &ray) override;
    void set_surface_parameter(std::string model, std::string shadowing, double factor, double shadowing_factor) override;

    [[nodiscard]] double focal_length() const override {
      return focal_length_;
    };

 private:
  sixte::XMLNode raytracing_node_;
    double mirror_height;
    double distance_to_mirror;
    double sensor_offset;

    EmbreeScene shapes;

    double focal_length_;

    void create_parameters(double new_radius, Paraboloid_parameters &p_pars, Hyperboloid_parameters &h_pars) const;
    void create() override;
};

