/*
    This file is part of SIXTE.

    SIXTE is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    SIXTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License see
    <http://www.gnu.org/licenses/>.


    Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
    Erlangen-Nuernberg
*/

#pragma once

#include "SixteVector.h"

#include "raytracing/geometry/Ray.h"
#include "XMLData.h"


class MirrorModule {
public:
    virtual ~MirrorModule() = default;
    [[nodiscard]] virtual std::unique_ptr<MirrorModule> clone() const = 0;
    virtual std::optional<Ray> ray_trace(Ray &ray) = 0;
    virtual std::optional<Ray> ray_trace_optics(Ray &ray) { return ray_trace(ray); }
    virtual std::optional<Ray> ray_trace_terminal(Ray &ray) { return ray; }
    virtual void set_surface_parameter(std::string model, std::string shadowing, double factor, double shadowing_factor) = 0;
    [[nodiscard]] virtual double focal_length() const = 0;
    [[nodiscard]] virtual double entrance_plane_z() const { return focal_length(); }
private:
    virtual void create() = 0;
};

