/*
    This file is part of SIXTE.

    SIXTE is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    SIXTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License see
    <http://www.gnu.org/licenses/>.


    Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
    Erlangen-Nuernberg
*/

#pragma once

#include "raytracing/shape/Shape.h"
#include "raytracing/shape/Hyperboloid.h"
#include "raytracing/shape/Paraboloid.h"
#include "raytracing/shape/Plane.h"
#include "raytracing/sensor/Sensor.h"
#include "raytracing/shape/Spider.h"
#include "raytracing/mesh_reading/stl_reader.h"
#include "raytracing/surface/Reflectivity.h"
#include <embree4/rtcore.h>
#include <optional>

class EmbreeScene {
public:
    EmbreeScene();
    EmbreeScene(const EmbreeScene&) = default;
    EmbreeScene& operator=(const EmbreeScene&) = default;

    EmbreeScene(EmbreeScene&&) noexcept = default;
    EmbreeScene& operator=(EmbreeScene&&) noexcept = default;

    ~EmbreeScene() = default;

    [[nodiscard]] std::optional<Ray> ray_trace(Ray &ray);
    RTCScene initializeScene(RTCDevice device);
    static RTCDevice initializeDevice();
    static unsigned int addSTLMesh(const std::string& path, const Vec3fa& position, RTCScene& scene, RTCDevice& device);
    static unsigned int addSTLMesh(const std::string& path, const Vec3fa& position, RTCScene& scene, RTCDevice& device, std::vector<Vec3fa> &points);

    std::vector<Hyperboloid> hyperboloids{};
    std::vector<Paraboloid> paraboloids{};
    Spider spider{};
    Plane sensor;
    RTCScene scene;
    RTCDevice device;
    sixte::SurfaceElement mirror_coating;

private:
    static void errorFunction(void* userPtr, enum RTCError error, const char* str);
    bool embree_ray_trace(Ray &ray, int depth);
    std::shared_ptr<SurfaceModel> find_surface_model(unsigned int geomID);
    bool reflect_ray(Ray &ray);

    std::shared_ptr<SurfaceModel> surfaceModel = nullptr;

};
