/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
   Erlangen-Nuernberg
*/

#pragma once

#include "Vec3fa.h"
#include <embree4/rtcore.h>
#include <vector>

enum class RayFailReason {
  UNSET = 0,
  NONE,
  MISSED_OPTIC,
  LOST_IN_PORE,
  DIRECT_SENSOR_HIT,
  BLOCKED_SPIDER,
  MISSED_SENSOR,
  MAX_DEPTH,
  TOO_SHALLOW
};

struct shape_id {
    shape_id(short id, const Vec3fa &origin, const Vec3fa &direction) : id(id), origin(origin), direction(direction) {}
    short id{};
    Vec3fa origin, direction;
};

class Ray {
public:
    Ray(const Vec3fa &position, Vec3fa &direction, double energy);

    [[nodiscard]] Vec3fa direction() const;
    [[nodiscard]] Vec3fa position() const;
    [[nodiscard]] Vec3fa normal() const;
    [[nodiscard]] RayFailReason fail_reason() const;
    void set_direction(const Vec3fa& v);
    void set_position(const Vec3fa& v);
    void set_normal(const Vec3fa& v);
    void set_fail_reason(RayFailReason reason);
    void reset_rayhit(float tnear = 0.0001f);

    double energy;
    std::vector<shape_id> raytracing_history{};
    RTCRayHit rayhit{};
    unsigned int hitID{};
    Vec2fa sensor_position{};
    RayFailReason ray_fail_reason = RayFailReason::UNSET;
};
