/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2025 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#include "Ray.h"

Ray::Ray(const Vec3fa &position, Vec3fa& direction, double energy)
: energy(energy) {
    if (not (direction.x == 0 and  direction.y == 0 and direction.z == 0)) {
        direction = normalize(direction);
    }
    rayhit.ray.org_x = position.x;
    rayhit.ray.org_y = position.y;
    rayhit.ray.org_z = position.z;
    rayhit.ray.dir_x = direction.x;
    rayhit.ray.dir_y = direction.y;
    rayhit.ray.dir_z = direction.z;
    rayhit.ray.tnear = 0.0001;
    rayhit.ray.tfar = std::numeric_limits<float>::infinity();
    rayhit.ray.mask = -1;
    rayhit.ray.flags = 0;
    rayhit.hit.geomID = RTC_INVALID_GEOMETRY_ID;
    rayhit.hit.instID[0] = RTC_INVALID_GEOMETRY_ID;
}

Vec3fa Ray::direction() const {
    return {rayhit.ray.dir_x, rayhit.ray.dir_y, rayhit.ray.dir_z};
}

Vec3fa Ray::position() const {
    return {rayhit.ray.org_x, rayhit.ray.org_y, rayhit.ray.org_z};
}

Vec3fa Ray::normal() const {
    return {rayhit.hit.Ng_x, rayhit.hit.Ng_y, rayhit.hit.Ng_z};
}

RayFailReason Ray::fail_reason() const {
    return ray_fail_reason;
}

void Ray::set_direction(const Vec3fa &v) {
    rayhit.ray.dir_x = v.x;
    rayhit.ray.dir_y = v.y;
    rayhit.ray.dir_z = v.z;
}

void Ray::set_position(const Vec3fa &v) {
    rayhit.ray.org_x = v.x;
    rayhit.ray.org_y = v.y;
    rayhit.ray.org_z = v.z;
}

void Ray::set_normal(const Vec3fa &v) {
    rayhit.hit.Ng_x = v.x;
    rayhit.hit.Ng_y = v.y;
    rayhit.hit.Ng_z = v.z;
}

void Ray::set_fail_reason(RayFailReason reason) {
    ray_fail_reason = reason;
}

void Ray::reset_rayhit(float tnear) {
    rayhit.ray.tnear = tnear;
    rayhit.ray.tfar = std::numeric_limits<float>::infinity();
    rayhit.ray.mask = -1;
    rayhit.ray.flags = 0;
    rayhit.hit.geomID = RTC_INVALID_GEOMETRY_ID;
    rayhit.hit.primID = 0;
    rayhit.hit.instID[0] = RTC_INVALID_GEOMETRY_ID;
}
