/*
   This file is part of SIXTE.

   SIXTE is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   any later version.

   SIXTE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   For a copy of the GNU General Public License see
   <http://www.gnu.org/licenses/>.


   Copyright 2022 Remeis-Sternwarte, Friedrich-Alexander-Universitaet
                  Erlangen-Nuernberg
*/

#pragma once

#include <string>

namespace sixte {

/**
 * Requests or reads the value of specified integer parameter from parameter
 * file or command line, depending on the mode set in par file.
 */
int queryParameterInt(const std::string& parameter_name);

/**
 * Requests or reads the value of specified long parameter from parameter
 * file or command line, depending on the mode set in par file.
 */
long queryParameterLong(const std::string& parameter_name);

/**
 * Requests or reads the value of specified float parameter from parameter
 * file or command line, depending on the mode set in par file.
 */
float queryParameterFloat(const std::string& parameter_name);

/**
 * Requests or reads the value of specified double (real) parameter from parameter
 * file or command line, depending on the mode set in par file.
 */
double queryParameterDouble(const std::string& parameter_name);

/**
 * Requests or reads the value of specified string parameter from parameter
 * file or command line, depending on the mode set in par file.
 */
std::string queryParameterString(const std::string& parameter_name);

/**
 * Requests or reads the value of specified boolean parameter from parameter
 * file or command line, depending on the mode set in par file.
 */
bool queryParameterBool(const std::string& parameter_name);

}
